/*
 * Plugin to change chrome color of rich text editor on focus and blur.  Requires the following to be
 * specified in the CKEdit config:
 *		extraPlugins: 		'fadeOnBlur'
 *
 * Also supports the following configuration options:
 * 
 * 		fadeBlurColor:		The color to use when the rich editor is blurred.  Defaults to '#f8f8f8'.
 * 		fadeBlurOpacity:	The percentage opacity to use on the toolbar when the rich editor does not
 * 							have focus.  Defaults to 25.
 * 		fadeFocusColor:		The color to use when the rich editor is blurred.  Defaults to '#eeeeee'.
 * 		fadeFocusOpacity:	The percentage opacity to use on the toolbar when the rich editor has focus.
 * 							Defaults to 100.
 */
CKEDITOR.plugins.add( 'fadeOnBlur',
{
    init: function(editor) {
				var		defaultBlurColor = '#f8f8f8';
				var		defaultBlurOpacity = 25;
				var		defaultFocusOpacity = 100;

				var		blurColor = defaultBlurColor;
				var		blurOpacity = defaultBlurOpacity / 100;
				var		focusOpacity = defaultFocusOpacity / 100;

				var		editorHasFocus = false;

				var		standardUiColor = null;		/* Will be grabbed when necessary. */

				if (true) {
					function toolbarId(editor) {
						return 'cke_top_' + editor.name;
					}

					function getUiColor(editor) {
						var		standardUiColor = editor.getUiColor();
						
						if (!standardUiColor) {
							var		$frame = $('.cke_editor_' + editor.name + ' .cke_wrapper');

							standardUiColor = $frame.css('background-color');
						}
						
						return standardUiColor;
					}

					function onEditorFocus() {
						var		options = {
											opacity: focusOpacity
										  };

			            editorHasFocus = false;
			            editor.setUiColor(standardUiColor);
			            $('#' + toolbarId(editor)).animate(options, 200);
					}

					function onEditorBlur() {
						var		options = {
											opacity: blurOpacity
										  };

						editorHasFocus = false;
			            editor.setUiColor(blurColor);

			            $('#' + toolbarId(editor)).animate(options, 200);
					}

					editor.on('instanceReady', function(event) {
													standardUiColor = getUiColor(editor);

										            if (editor.config.fadeBlurColor)
										            {
										            	blurColor = editor.config.fadeBlurColor;
										            }
			
										            if (editor.config.fadeBlurOpacity)
										            {
										            	blurOpacity = editor.config.fadeBlurOpacity;
										            }
	
										            if (editor.config.fadeFocusColor)
										            {
										            	focusColor = editor.config.fadeFocusColor;
										            }
	
										            if (editor.config.fadeFocusOpacity)
										            {
										            	focusOpacity = editor.config.fadeFocusOpacity / 100;
										            }
	
										            if (editor.config.startupFocus)
										            {
										            	editorHasFocus = editor.config.startupFocus;
										            	onEditorFocus();
										            }
										            else {
										            	onEditorBlur();
										            }
				         						}, editor, null, 100);

					editor.on('focus', function(event) {
												onEditorFocus();
									         }, editor, null, 100);
			
					editor.on('blur', function(event) {
												onEditorBlur();
									         }, editor, null, 100);
				}
			}
});
